/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.debug.core;

import com.aptana.ruby.debug.core.IRubyLineBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyExceptionBreakpoint;
import com.aptana.ruby.debug.core.model.IRubyStackFrame;
import com.aptana.ruby.internal.debug.core.ICommandFactory;
import com.aptana.ruby.internal.debug.core.model.RubyStackFrame;
import com.aptana.ruby.internal.debug.core.model.RubyThread;
import com.aptana.ruby.internal.debug.core.model.RubyVariable;
import org.eclipse.core.runtime.CoreException;

public class ClassicDebuggerCommandFactory
implements ICommandFactory {
    @Override
    public String createReadFrames(RubyThread thread) {
        return "th " + thread.getId() + " ; w";
    }

    @Override
    public String createReadLocalVariables(RubyStackFrame frame) {
        return "th " + ((RubyThread)frame.getThread()).getId() + " ; frame " + frame.getIndex() + " ; v l ";
    }

    @Override
    public String createReadInstanceVariable(RubyVariable variable) {
        return "th " + ((RubyThread)variable.getStackFrame().getThread()).getId() + " ; v i " + variable.getStackFrame().getIndex() + " " + variable.getObjectId();
    }

    @Override
    public String createStepOver(RubyStackFrame stackFrame) {
        return "th " + ((RubyThread)stackFrame.getThread()).getId() + " ; next";
    }

    @Override
    public String createForcedStepOver(RubyStackFrame stackFrame) {
        return this.createStepOver(stackFrame);
    }

    @Override
    public String createStepReturn(RubyStackFrame stackFrame) {
        return "th " + ((RubyThread)stackFrame.getThread()).getId() + " ; next " + (stackFrame.getLineNumber() + 1);
    }

    @Override
    public String createStepInto(RubyStackFrame stackFrame) {
        return "th " + ((RubyThread)stackFrame.getThread()).getId() + " ; step";
    }

    @Override
    public String createForcedStepInto(RubyStackFrame stackFrame) {
        return this.createStepInto(stackFrame);
    }

    @Override
    public String createReadThreads() {
        return "th l";
    }

    @Override
    public String createLoad(String filename) {
        return "load " + filename;
    }

    @Override
    public String createInspect(IRubyStackFrame frame, String expression) {
        return "th " + ((RubyThread)frame.getThread()).getId() + " ; v inspect " + frame.getIndex() + " " + expression;
    }

    @Override
    public String createResume(RubyThread thread) {
        return "th " + thread.getId() + ";cont";
    }

    @Override
    public String createAddBreakpoint(String file, int line) {
        StringBuffer setBreakPointCommand = new StringBuffer();
        setBreakPointCommand.append("b ");
        setBreakPointCommand.append(file);
        setBreakPointCommand.append(":");
        setBreakPointCommand.append(line);
        return setBreakPointCommand.toString();
    }

    @Override
    public String createRemoveBreakpoint(int index) {
        return "delete " + index;
    }

    @Override
    public String createCatchOff(IRubyExceptionBreakpoint breakpoint) {
        return "catch off";
    }

    @Override
    public String createCatchOn(IRubyExceptionBreakpoint breakpoint) throws CoreException {
        return "catch " + breakpoint.getTypeName();
    }

    @Override
    public String createThreadStop(RubyThread thread) {
        return "th stop " + thread.getId();
    }

    @Override
    public String createAddMethodBreakpoint(String file, String typeName, String methodName, int line) {
        StringBuffer setBreakPointCommand = new StringBuffer();
        setBreakPointCommand.append("b ");
        setBreakPointCommand.append(file);
        setBreakPointCommand.append(":");
        setBreakPointCommand.append(line);
        return setBreakPointCommand.toString();
    }

    @Override
    public String createSetCondition(IRubyLineBreakpoint lineBreakpoint) throws CoreException {
        return null;
    }
}

